﻿IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalHealthProviderIndividualUpdate]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [hips].[HospitalHealthProviderIndividualUpdate]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Create date:	  16 October 2015
-- Description:   Updates an existing record into the Hospital Health Care Provider Table
-- =============================================

CREATE PROCEDURE [hips].[HospitalHealthProviderIndividualUpdate] 
(
	@HospitalId INT,
	@HealthProviderIndividualId INT,
	@CisProviderIdentifier VARCHAR(30) = NULL,
	@PasProviderIdentifier VARCHAR(30),	
	@UserModified VARCHAR(256)	
) 
AS
BEGIN
	SET NOCOUNT ON

	DECLARE @intErrorCode INT
          
    SET @intErrorCode = 0
    UPDATE [hips].[HospitalHealthProviderIndividual]
    SET		CisProviderIdentifier = @CisProviderIdentifier,
			PasProviderIdentifier = @PasProviderIdentifier,
			DateModified = GETDATE(),
			UserModified = @UserModified
	WHERE HospitalId = @HospitalId
	AND HealthProviderIndividualId = @HealthProviderIndividualId
	
	SELECT @intErrorCode = @@ERROR 
    IF @intErrorCode = 0
    BEGIN
	SELECT
			  HospitalId ,
	          HealthProviderIndividualId ,
	          CisProviderIdentifier ,
	          PasProviderIdentifier ,
	          DateCreated ,
	          UserCreated ,
	          DateModified ,
	          UserModified
	FROM [hips].[HospitalHealthProviderIndividual]
	WHERE @HospitalId = HospitalId
	AND   @HealthProviderIndividualId = HealthProviderIndividualId

    END

    RETURN(@intErrorCode)

END
